%% Optical camera overlay for CAE acoustic camera
% Bieke von den Hoff
% PhD student ANCE - Aerospace Engineering - TU Delft 
% Version October 1, 2020

% In main file the following should be specified:
% data.start_sample - time of starting the snapshot (s)
% data.end_sample - time of ending the snapshot (s)
% info.fs - sampling frequency (Hz)
% meteo.c - speed of sound in air (m/s)
% X_grid & Y_grid - scan plane grid (m)
% h - normal distance between array centre and scan plane (centre) (m)
% BF_source - CB source map (dB)
% video struct - this comes straight from the Read_data_CAE code 

%% If you want to check out the video of the measurements, run the following snippet of code - adapted from DEMO optical camera
% fig = figure(1);
% tb = uicontrol(fig, 'Style', 'togglebutton', 'String', 'Start/stop');
% drawnow;

% for i=1:size(video.images,3) 
%     h1 = imshow(video.images(:,:,i));
%     text(-10,-10,num2str(i)) % plot frame number in top left corner
%     while true
%         drawnow;
%          if (get(tb, 'Value')==1); break; end
%     end
% end

%% Select the optical frame corresponding to the beamforming time sample
[~,frame_select] = min(abs(video.timestamp - ((data.start_sample + (data.end_sample - data.start_sample)/2)/info.fs-h/meteo.c)));

if(isempty(frame_select) || frame_select > video.n_frames)              % In case there is no frame selected or a frame that doesnt exist.
    disp(['Warning! Selected video frame is ' num2str(frame_select) ' while number of images is ' num2str(video.n_frames)]);
    disp('Instead, the last frame will be selected');
    frame_select = video.n_frames;
end

%% Calculate the corner coordinates of the image (m) for Z specified
% Based on camera specs: 45deg Field of View (center to corner), 240 pix height, 376 pix width
video.w = sqrt(4391/1545)*h;
video.h = 240/376*video.w;

video.X = linspace(-1/2*video.w,1/2*video.w,376);
video.Y = linspace(-1/2*video.h,1/2*video.h,240);
  
%% Plot the overlay
% Note: by default imagesc has the y-axis reversed (uses set(gca,'YDir','Reverse')), therefore flipud and set(gca,'YDir','Normal')
figure
h1 = imagesc(video.X, video.Y, flipud(ind2rgb(video.images(:,:,frame_select),gray(256))));  % Plot image of optical camera                      % PLOT THE VIDEO PICTURE.
set(h1,'AlphaData', 0.6)                                                  % Controls the contrast/transparency of the background image 1=darker/0=brighter
set(gca,'YDir','Normal')

hold on
h2 = pcolor(X_grid, Y_grid, BF_source);                     % Plot beamforming picture
set(h2, 'facealpha', 0.2)                                              % AlphaData determines transparency of source plot color overlay 
hold off

xlabel('x (m)')     % Define axis, labels and look of the beamform plot
ylabel('y (m)')
caxis([max(max(BF_source))-10 max(max(BF_source))+0]);
shading flat
colormap(jet)
cb = colorbar;
cb.Label.String = 'SPL (dB) ';
hf = get(gcf,'Children');
set(hf,'FontSize',20)










